/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.AbstractSplitterTE;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BasicItemSplitterTileEntity
extends AbstractSplitterTE {
    @ObjectHolder(value="basic_item_splitter")
    public static BlockEntityType<BasicItemSplitterTileEntity> TYPE = null;
    private final ItemStack[] inventory = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_};
    private int transferred = 0;
    private LazyOptional<IItemHandler> primaryOpt = LazyOptional.of(() -> new OutItemHandler(1));
    private LazyOptional<IItemHandler> secondaryOpt = LazyOptional.of(() -> new OutItemHandler(0));
    private LazyOptional<IItemHandler> inOpt = LazyOptional.of(() -> new InHandler());

    public BasicItemSplitterTileEntity(BlockEntityType<? extends AbstractSplitterTE> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BasicItemSplitterTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
        this.primaryOpt = LazyOptional.of(() -> new OutItemHandler(1));
        this.secondaryOpt = LazyOptional.of(() -> new OutItemHandler(0));
        this.inOpt = LazyOptional.of(() -> new InHandler());
        this.endPos[1] = null;
        this.endPos[0] = null;
    }

    @Override
    public void serverTick() {
        if (this.endPos[0] == null || this.endPos[1] == null) {
            this.refreshCache();
        }
        Direction dir = this.getFacing();
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = AbstractShifterTileEntity.ejectItem(this.f_58857_, this.endPos[i], i == 0 ? dir : dir.m_122424_(), this.inventory[i], null);
        }
        this.m_6596_();
    }

    public void m_7651_() {
        super.m_7651_();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Direction dir = this.getFacing();
            return side == dir ? this.primaryOpt : (side == dir.m_122424_() ? this.secondaryOpt : this.inOpt);
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128344_("type", (byte)1);
        nbt.m_128405_("mode", this.mode);
        nbt.m_128405_("transferred", this.transferred);
        for (int i = 0; i < 2; ++i) {
            if (this.inventory[i].m_41619_()) continue;
            CompoundTag inner = new CompoundTag();
            this.inventory[i].m_41739_(inner);
            nbt.m_128365_("inv_" + i, (Tag)inner);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mode = nbt.m_128445_("type") == 1 ? nbt.m_128451_("mode") : 3 + 3 * nbt.m_128451_("mode");
        this.transferred = nbt.m_128451_("transferred");
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("inv_" + i));
        }
    }

    private class InHandler
    implements IItemHandler {
        private InHandler() {
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int goDown;
            int accepted;
            if (stack.m_41619_() || slot != 0) {
                return stack;
            }
            if (!BasicItemSplitterTileEntity.this.inventory[0].m_41619_() && !BlockUtil.sameItem(stack, BasicItemSplitterTileEntity.this.inventory[0]) || !BasicItemSplitterTileEntity.this.inventory[1].m_41619_() && !BlockUtil.sameItem(stack, BasicItemSplitterTileEntity.this.inventory[1])) {
                return stack;
            }
            int numerator = BasicItemSplitterTileEntity.this.getMode();
            AbstractSplitterTE.SplitDistribution distribution = BasicItemSplitterTileEntity.this.getDistribution();
            int denominator = distribution.base;
            int spaceDown = stack.m_41741_() - BasicItemSplitterTileEntity.this.inventory[0].m_41613_();
            int spaceUp = stack.m_41741_() - BasicItemSplitterTileEntity.this.inventory[1].m_41613_();
            if (numerator == 0) {
                accepted = Math.min(spaceUp, stack.m_41613_());
                goDown = 0;
            } else if (numerator == denominator) {
                goDown = accepted = Math.min(spaceDown, stack.m_41613_());
            } else {
                int baseQty = stack.m_41613_() - stack.m_41613_() % denominator;
                accepted = denominator * spaceDown / numerator;
                accepted = Math.min(accepted, denominator * spaceUp / (denominator - numerator));
                if ((accepted = Math.max(0, Math.min(baseQty, accepted))) % denominator != 0) {
                    accepted -= accepted % denominator;
                }
                goDown = numerator * accepted / denominator;
                spaceDown -= goDown;
                spaceUp -= accepted - goDown;
                int remainder = stack.m_41613_() - accepted;
                for (int i = 0; i < remainder; ++i) {
                    boolean shouldGoDown = distribution.shouldDispense(BasicItemSplitterTileEntity.this.mode, BasicItemSplitterTileEntity.this.transferred + i);
                    if (shouldGoDown) {
                        if (spaceDown <= 0) break;
                        --spaceDown;
                        ++goDown;
                        ++accepted;
                        continue;
                    }
                    if (spaceUp <= 0) break;
                    --spaceUp;
                    ++accepted;
                }
            }
            int goUp = accepted - goDown;
            if (!simulate && accepted != 0) {
                if (BasicItemSplitterTileEntity.this.inventory[0].m_41619_()) {
                    BasicItemSplitterTileEntity.this.inventory[0] = stack.m_41777_();
                    BasicItemSplitterTileEntity.this.inventory[0].m_41764_(goDown);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[0].m_41769_(goDown);
                }
                if (BasicItemSplitterTileEntity.this.inventory[1].m_41619_()) {
                    BasicItemSplitterTileEntity.this.inventory[1] = stack.m_41777_();
                    BasicItemSplitterTileEntity.this.inventory[1].m_41764_(goUp);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[1].m_41769_(goUp);
                }
                BasicItemSplitterTileEntity.this.transferred += accepted;
                BasicItemSplitterTileEntity.this.transferred %= denominator;
            }
            if (accepted > 0) {
                ItemStack out = stack.m_41777_();
                out.m_41774_(accepted);
                return out;
            }
            return stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }

    protected class OutItemHandler
    implements IItemHandler {
        private final int index;

        private OutItemHandler(int index) {
            this.index = index;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot != 0 ? ItemStack.f_41583_ : BasicItemSplitterTileEntity.this.inventory[this.index];
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return ItemStack.f_41583_;
            }
            int moved = Math.min(amount, BasicItemSplitterTileEntity.this.inventory[this.index].m_41613_());
            if (simulate) {
                return new ItemStack((ItemLike)BasicItemSplitterTileEntity.this.inventory[this.index].m_41720_(), moved, BasicItemSplitterTileEntity.this.inventory[this.index].m_41783_());
            }
            BasicItemSplitterTileEntity.this.m_6596_();
            return BasicItemSplitterTileEntity.this.inventory[this.index].m_41620_(moved);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }
}

